import numpy as np
import pandas as pd
import os
import re

#import files
path=r'xxxx'
df_Cap=pd.read_excel(path,'Company-Capacity') 
df_CountryEC=pd.read_excel(path,'2019EC-pro') #Energy consumption data-datasource：IEA

#del zz unidentified plants
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','EAF steel']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','BOF steel']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','OHF steel']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','DRI']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','total pig iron']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','BF pig iron']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','other pig iron']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','coke']=0
df_Cap.loc[df_Cap['Plant Name']=='zz unidentified plants','sinter']=0

#Country-level Capacity (Crude steel+ Total pig iron+ DRI+coke+sinter+processed)
df_CountryCapTotal=df_Cap.groupby(['Plant Country'])['Total output'].sum() 


#Country-level energy consumption rate 
data_mergeEC=pd.merge(df_CountryCapTotal, df_CountryEC, on='Plant Country', how='outer')
data_mergeEC.fillna(0, inplace=True)

data_mergeEC[['RateAnthracite (kt)','RateCoking coal (kt)','RateOther bituminous coal (kt)','RateSub-bituminous coal (kt)','RateLignite (kt)','RatePatent fuel (kt)','RateCoke oven coke (kt)',
               'RateGas coke (kt)','Coal tar (kt)','BKB (kt)','RateGas works gas (TJ-gross)','RateCoke oven gas (TJ-gross)','RateBlast furnace gas (TJ-gross)',
               'RateOther recovered gases (TJ-gross)','RatePeat (kt)','RateNatural gas (TJ-gross)','RateCrude oil (kt)','RateNatural gas liquids (kt)',
               'RateRefinery feedstocks (kt)','RateRefinery gas (kt)','RateEthane (kt)','RateLiquefied petroleum gases (LPG) (kt)','RateMotor gasoline excl. biofuels (kt)',
               'RateAviation gasoline (kt)','RateGasoline type jet fuel (kt)','RateKerosene type jet fuel excl. biofuels (kt)','RateOther kerosene (kt)',
               'RateGas/diesel oil excl. biofuels (kt)','RateFuel oil (kt)','RateNaphtha (kt)','RateWhite spirit & SBP (kt)','RateLubricants (kt)','RateBitumen (kt)',
               'RateParaffin waxes (kt)','RatePetroleum coke (kt)','RateOther oil products (kt)','RateIndustrial waste (TJ-net)','RateMunicipal waste (renewable) (TJ-net)',
               'RateMunicipal waste (non-renewable) (TJ-net)','RatePrimary solid biofuels (TJ-net)','RateBiogases (TJ-net)','RateBiogasoline (kt)','RateBiodiesels (kt)',
               'RateOther liquid biofuels (kt)','RateCharcoal (kt)','RateElectricity (GWh)','RateHeat (TJ)','RateSolar thermal (direct use in TJ-net)']] = \
data_mergeEC[['Anthracite (kt)','Coking coal (kt)','Other bituminous coal (kt)','Sub-bituminous coal (kt)','Lignite (kt)','Patent fuel (kt)','Coke oven coke (kt)',
               'Gas coke (kt)','Coal tar (kt)','BKB (kt)','Gas works gas (TJ-gross)','Coke oven gas (TJ-gross)','Blast furnace gas (TJ-gross)',
               'Other recovered gases (TJ-gross)','Peat (kt)','Natural gas (TJ-gross)','Crude oil (kt)','Natural gas liquids (kt)',
               'Refinery feedstocks (kt)','Refinery gas (kt)','Ethane (kt)','Liquefied petroleum gases (LPG) (kt)','Motor gasoline excl. biofuels (kt)',
               'Aviation gasoline (kt)','Gasoline type jet fuel (kt)','Kerosene type jet fuel excl. biofuels (kt)','Other kerosene (kt)',
               'Gas/diesel oil excl. biofuels (kt)','Fuel oil (kt)','Naphtha (kt)','White spirit & SBP (kt)','Lubricants (kt)','Bitumen (kt)',
               'Paraffin waxes (kt)','Petroleum coke (kt)','Other oil products (kt)','Industrial waste (TJ-net)','Municipal waste (renewable) (TJ-net)',
               'Municipal waste (non-renewable) (TJ-net)','Primary solid biofuels (TJ-net)','Biogases (TJ-net)','Biogasoline (kt)','Biodiesels (kt)',
               'Other liquid biofuels (kt)','Charcoal (kt)','Electricity (GWh)','Heat (TJ)','Solar thermal (direct use in TJ-net)']].div(data_mergeEC['Total output'].values,axis=0)

data_mergeEC.replace([np.inf, -np.inf], np.nan, inplace=True)
data_mergeEC.fillna(0, inplace=True) 
del data_mergeEC['Total output'] 

#data_mergeEC=data_mergeEC.astype('double')
#data_mergeEAF[['EAF', 'EAF steel', 'EAFOperationRate']] = data_mergeEAF[['EAF', 'EAF steel', 'EAFOperationRate']].astype('double') 
#del data_mergeEAF['EAF steel'] 


#Plant-level Energy consumption（withoutzz unidentified plants）
from functools import reduce


#df_groups = [df_Cap,data_mergeEAF, data_mergeBOF, data_mergeOHF, data_mergeDRI,data_mergePigiron,data_mergeCoke,data_mergeSinter]
#df_mergedplant = reduce(lambda left, right: pd.merge(left, right, on='Plant Country', how='outer'), df_groups)

data_mergePlantEC=pd.merge(df_Cap, data_mergeEC, on='Plant Country', how='inner')

#计算

data_mergePlantEC[['Anthracite','Coking coal','Other bituminous coal','Sub-bituminous coal','Lignite','Patent fuel','Coke oven coke',
               'Gas coke','Coal tar','BKB','Gas works gas','Coke oven gas','Blast furnace gas',
               'Other recovered gases','Peat','Natural gas','Crude oil','Natural gas liquids',
               'Refinery feedstocks','Refinery gas','Ethane','Liquefied petroleum gases (LPG)','Motor gasoline excl. biofuels',
               'Aviation gasoline','Gasoline type jet fuel','Kerosene type jet fuel excl. biofuels','Other kerosene',
               'Gas/diesel oil excl. biofuels','Fuel oil','Naphtha','White spirit & SBP','Lubricants','Bitumen',
               'Paraffin waxes','Petroleum coke','Other oil products','Industrial waste','Municipal waste (renewable)',
               'Municipal waste (non-renewable)','Primary solid biofuels','Biogases','Biogasoline','Biodiesels',
               'Other liquid biofuels','Charcoal','proElectricity (GWh)','proHeat (TJ)','proSolar thermal (direct use in TJ-net)']]=\
data_mergePlantEC[['RateAnthracite (kt)','RateCoking coal (kt)','RateOther bituminous coal (kt)','RateSub-bituminous coal (kt)','RateLignite (kt)','RatePatent fuel (kt)','RateCoke oven coke (kt)',
               'RateGas coke (kt)','Coal tar (kt)','BKB (kt)','RateGas works gas (TJ-gross)','RateCoke oven gas (TJ-gross)','RateBlast furnace gas (TJ-gross)',
               'RateOther recovered gases (TJ-gross)','RatePeat (kt)','RateNatural gas (TJ-gross)','RateCrude oil (kt)','RateNatural gas liquids (kt)',
               'RateRefinery feedstocks (kt)','RateRefinery gas (kt)','RateEthane (kt)','RateLiquefied petroleum gases (LPG) (kt)','RateMotor gasoline excl. biofuels (kt)',
               'RateAviation gasoline (kt)','RateGasoline type jet fuel (kt)','RateKerosene type jet fuel excl. biofuels (kt)','RateOther kerosene (kt)',
               'RateGas/diesel oil excl. biofuels (kt)','RateFuel oil (kt)','RateNaphtha (kt)','RateWhite spirit & SBP (kt)','RateLubricants (kt)','RateBitumen (kt)',
               'RateParaffin waxes (kt)','RatePetroleum coke (kt)','RateOther oil products (kt)','RateIndustrial waste (TJ-net)','RateMunicipal waste (renewable) (TJ-net)',
               'RateMunicipal waste (non-renewable) (TJ-net)','RatePrimary solid biofuels (TJ-net)','RateBiogases (TJ-net)','RateBiogasoline (kt)','RateBiodiesels (kt)',
               'RateOther liquid biofuels (kt)','RateCharcoal (kt)','RateElectricity (GWh)','RateHeat (TJ)','RateSolar thermal (direct use in TJ-net)']].multiply(data_mergePlantEC['Total output'].values,axis=0)


data_mergePlantEC.replace([np.inf, -np.inf], np.nan, inplace=True)
data_mergePlantEC.fillna(0, inplace=True) 

outpath=r'xxxxx'
data_mergePlantEC.to_csv(outpath+r'\Global Steeplant capacity and energy consumption.csv')
print('Done')